
Select and copy this program to a new file  with extention .c.

/**********************************************************/
/*          A simple Data Base Program                    */
/**********************************************************/

# include &lt;stdio.h&gt;
# include &lt;stdlib.h&gt;
# include &lt;string.h&gt;

# define MAX 100  /* constant*/

struct addr {                  /*struct called list*/
             char name[30]   ;
             char street[40] ;
             char town[20]   ;
             char county[20] ;
             char code[10]   ;
            } list[MAX];       /* 100 records*/

main()
{
    int choice;

    init_list();      /* initialze the list */

    for(;;) {
      choice = menu_select();    /* get user's selection*/        switch(choice) {
        case 1: enter();         /* enter a new entry */
                break;
        case 2: del();           /* delete an entry */
                break;
        case 3: show_list();     /* display the list */
                break;
        case 4: search();        /* find an entry */
                break;
        case 5: save();          /* save to disk */
                break;
        case 6: load();          /* read from disk */
                break;
        case 7: exit(0);
      }
    }
}

/*********************************************************/
/*         Function del                                  */
/*********************************************************/
del()
{
    int i;
    char str[255];

    inputs("enter name: " , str , 30);
    i = find(str);
    if (i>=0) *list[i].name = '\0'   ;
    else      printf("not found\n")  ;
}


/**********************************************************/
/*                   Function display                     */
/**********************************************************/
display(int i)
{
    printf("%s\n" , list[i].name);
    printf("%s\n" , list[i].street);
    printf("%s\n" , list[i].town);
    printf("%s\n" , list[i].county);
    printf("%s\n" , list[i].code);
}

/**********************************************************/
/*                     Function enter                     */
/**********************************************************/
enter()
{
    int i;

    for(;;) {
      i = find_free();        /* find a free structure */
      if(i<0) {
        printf("list full\n");
        return;
      }
      inputs("enter name: ", list[i].name,30);        if(!*list[i].name) break;      /* stop entering */
      inputs("enter street: ", list[i].street, 40);
      inputs("enter town: ", list[i].town, 20);
      inputs("enter county: ", list[i].county, 20);
      inputs("enter Postal code: ", list[i].code, 10);
    }
}

/**********************************************************/
/*                       Function find                    */
/**********************************************************/
find(char *name)
{
    int i;  
    for(i=0 ; i<MAX ; i++) 
      if(!strcmp(name ,list[i].name)) break;
    if(i==MAX) return -1;
    else return i;
}

/**********************************************************/
/*                   Function find_free                   */
/**********************************************************/
find_free()
{
    register int i;   
    for(i=0; i<MAX; i++) 
      if(!*list[i].name) return i;  
    return -1;
}

/**********************************************************/
/*                      Function init_list                */
/**********************************************************/
init_list()
{
    register int i;   
    for (i=0 ; i<MAX ; i++) 
      *list[i].name = '\0';
}

/**********************************************************/
/*                    Function inputs                     */
/**********************************************************/
inputs( char *prompt , char *s , int count)
{
    char str[255];

    do {
        printf(prompt);
        gets(str);
        if(strlen(str)>=count) printf("\ntoo long\n");
       } while(strlen(str)>=count);

    strcpy(s , str);
}

/**********************************************************/
/*                         Function load                  */
/**********************************************************/
load()
{
    FILE *fp;

    if ( (fp=fopen("mlist" , "rb")) == NULL) {
       printf("cannot open file\n");
       return;
    }
    printf("\nloading file\n");
    fread(list , sizeof list , 1 , fp);
    if (ferror(fp)) 
       printf("An error occurred while reading file.\n");
    fclose(fp);
}

/**********************************************************/
/*                          Function menu_select          */
/**********************************************************/

menu_select()
{
    char s[80];
    int c;
    printf("1. Enter a name\n")  ;
    printf("2. Delete a name\n") ;
    printf("3. List the File \n");
    printf("4. Search\n")        ;
    printf("5. Save the file\n") ;
    printf("6. Load the file\n") ;
    printf("7. Quit\n")          ;

    do {
        printf("\nEnter your choice: ");
        gets(s);
        c = atoi(s);
       } while(c<0 || c>7);

    return c;
}

/**********************************************************/
/*                      Function save                     */
/**********************************************************/
save()
{
    FILE *fp;

    if ( (fp=fopen("mlist" , "wb")) == NULL) {
      printf("cannot open file\n");
      return;
    }
    printf("\nsaving file\n");
    fwrite(list , sizeof list , 1 , fp);
    if (ferror(fp)) 
      printf("An error occurred while writing file.\n");
    fclose(fp);
}

/**********************************************************/
/*                        Function search                 */
/**********************************************************/
search()
{
    int i;
    char name[30];

    inputs("enter name to find: " , name , 30);
    if ((i=find(name))<0) 
      printf("not found\n");
    else display(i);
}

/**********************************************************/
/*                         Function show_list             */
/**********************************************************/
show_list()
{
    int i;

    for(i=0 ; i&lt;MAX ; i++) {
      if(*list[i].name) {
        display(i);
        printf("\n\n");
      }
    }

    printf("\n\n");
}


