/*****************************************************************************/
/*                                                                           */
/*				     sig.h				     */
/*                                                                           */
/*		      Signals handling stuff for backupd		     */
/*                                                                           */
/*                                                                           */
/*                                                                           */
/* (C) 1998     Ullrich von Bassewitz                                        */
/*              Wacholderweg 14                                              */
/*              D-70597 Stuttgart                                            */
/* EMail:       uz@musoftware.de                                             */
/*                                                                           */
/*                                                                           */
/* This software is provided 'as-is', without any express or implied         */
/* warranty.  In no event will the authors be held liable for any damages    */
/* arising from the use of this software.                                    */
/*                                                                           */
/* Permission is granted to anyone to use this software for any purpose,     */
/* including commercial applications, and to alter it and redistribute it    */
/* freely, subject to the following restrictions:                            */
/*                                                                           */
/* 1. The origin of this software must not be misrepresented; you must not   */
/*    claim that you wrote the original software. If you use this software   */
/*    in a product, an acknowledgment in the product documentation would be  */
/*    appreciated but is not required.                                       */
/* 2. Altered source versions must be plainly marked as such, and must not   */
/*    be misrepresented as being the original software.                      */
/* 3. This notice may not be removed or altered from any source              */
/*    distribution.                                                          */
/*                                                                           */
/*****************************************************************************/



#ifndef SIG_H
#define SIG_H



#include <signal.h>	  
#include <setjmp.h>



/*****************************************************************************/
/*     	   	   	  	     Data				     */
/*****************************************************************************/



/* Jump label (used if a signal is catched) */
extern sigjmp_buf sigexit;

/* If we catch a signal, we store here the signal number */
extern sig_atomic_t sigcaught;



/*****************************************************************************/
/*     	       	   	  	     Code				     */
/*****************************************************************************/



void sigignore (int sig);
/* Ignore the given signal */

void sigset (int sig, void (*handler) (int));
/* Set a signal handler */

void sighandler (int sig);
/* This is our "catch-all" signal handler */



/* End of sig.h */

#endif



