/*****************************************************************************/
/*                                                                           */
/*				   client.h				     */
/*                                                                           */
/*		     Code handling client specific things		     */
/*                                                                           */
/*                                                                           */
/*                                                                           */
/* (C) 1998     Ullrich von Bassewitz                                        */
/*              Wacholderweg 14                                              */
/*              D-70597 Stuttgart                                            */
/* EMail:       uz@musoftware.de                                             */
/*                                                                           */
/*                                                                           */
/* This software is provided 'as-is', without any express or implied         */
/* warranty.  In no event will the authors be held liable for any damages    */
/* arising from the use of this software.                                    */
/*                                                                           */
/* Permission is granted to anyone to use this software for any purpose,     */
/* including commercial applications, and to alter it and redistribute it    */
/* freely, subject to the following restrictions:                            */
/*                                                                           */
/* 1. The origin of this software must not be misrepresented; you must not   */
/*    claim that you wrote the original software. If you use this software   */
/*    in a product, an acknowledgment in the product documentation would be  */
/*    appreciated but is not required.                                       */
/* 2. Altered source versions must be plainly marked as such, and must not   */
/*    be misrepresented as being the original software.                      */
/* 3. This notice may not be removed or altered from any source              */
/*    distribution.                                                          */
/*                                                                           */
/*****************************************************************************/



#ifndef CLIENT_H
#define CLIENT_H



/*****************************************************************************/
/*     	       	   	  	     Data				     */
/*****************************************************************************/



/* IP address of the client in host byte order */
extern unsigned long clientaddr;

/* Name or IP of the client in readable form */
extern char clientname [1024];



/*****************************************************************************/
/*     	       	   	  	     Code				     */
/*****************************************************************************/



void getclient (void);
/* Determine the name of the client. Abort on errors. */

int clientaccess (const char* res, const char* allow, const char* deny);
/* Determine if the client is allowed access the service according to the
 * allow and deny lists in the section res.
 */

void answer (const char* format, ...);
/* Send an answer to the client, check for errors */

void okanswer (void);
/* Send an OK to the client */

void erranswer (const char* msg, ...);
/* Send the given error message to the client */



/* End of client.h */

#endif



