/*****************************************************************************/
/*                                                                           */
/*				   extcmd.h				     */
/*                                                                           */
/*			Execution of external commands			     */
/*                                                                           */
/*                                                                           */
/*                                                                           */
/* (C) 1998     Ullrich von Bassewitz                                        */
/*              Wacholderweg 14                                              */
/*              D-70597 Stuttgart                                            */
/* EMail:       uz@musoftware.de                                             */
/*                                                                           */
/*                                                                           */
/* This software is provided 'as-is', without any express or implied         */
/* warranty.  In no event will the authors be held liable for any damages    */
/* arising from the use of this software.                                    */
/*                                                                           */
/* Permission is granted to anyone to use this software for any purpose,     */
/* including commercial applications, and to alter it and redistribute it    */
/* freely, subject to the following restrictions:                            */
/*                                                                           */
/* 1. The origin of this software must not be misrepresented; you must not   */
/*    claim that you wrote the original software. If you use this software   */
/*    in a product, an acknowledgment in the product documentation would be  */
/*    appreciated but is not required.                                       */
/* 2. Altered source versions must be plainly marked as such, and must not   */
/*    be misrepresented as being the original software.                      */
/* 3. This notice may not be removed or altered from any source              */
/*    distribution.                                                          */
/*                                                                           */
/*****************************************************************************/



#ifndef EXTCMD_H
#define EXTCMD_H



#include <stdio.h>



/*****************************************************************************/
/*     	       	   	  	     Data				     */
/*****************************************************************************/



/* File descriptor connected to the clients input/output */
extern FILE* clientio;



/*****************************************************************************/
/*     	       	   	  	     Code	      			     */
/*****************************************************************************/



void startcmd (const char* cmdline, const char* mode);
/* Start an external command with the given command line. The child will have
 * it's standard input or ouput connected to clientio.
 */

int endcmd (void);				      
/* Close the pipes to the child process and wait for it's termination. */



/* End of extcmd.h */

#endif



