/*****************************************************************************/
/*                                                                           */
/*				   config.h				     */
/*                                                                           */
/*		 Read configuration stuff from a config file.		     */
/*                                                                           */
/*                                                                           */
/*                                                                           */
/* (C) 1998     Ullrich von Bassewitz                                        */
/*              Wacholderweg 14                                              */
/*              D-70597 Stuttgart                                            */
/* EMail:       uz@musoftware.de                                             */
/*                                                                           */
/*                                                                           */
/* This software is provided 'as-is', without any express or implied         */
/* warranty.  In no event will the authors be held liable for any damages    */
/* arising from the use of this software.                                    */
/*                                                                           */
/* Permission is granted to anyone to use this software for any purpose,     */
/* including commercial applications, and to alter it and redistribute it    */
/* freely, subject to the following restrictions:                            */
/*                                                                           */
/* 1. The origin of this software must not be misrepresented; you must not   */
/*    claim that you wrote the original software. If you use this software   */
/*    in a product, an acknowledgment in the product documentation would be  */
/*    appreciated but is not required.                                       */
/* 2. Altered source versions must be plainly marked as such, and must not   */
/*    be misrepresented as being the original software.                      */
/* 3. This notice may not be removed or altered from any source              */
/*    distribution.                                                          */
/*                                                                           */
/*****************************************************************************/



#ifndef CONFIG_H
#define CONFIG_H



/*****************************************************************************/
/*                                   Data                                    */
/*****************************************************************************/



/* Name of the config file to use */
extern const char* configname;



/*****************************************************************************/
/*                                   Code                                    */
/*****************************************************************************/



int CfgGetInt (const char* Section, const char* Entry, long DefVal, long* Val);
/* Read an int from the config file. Val contains the result of the search, the
 * function return value tells if the entry has been found or not (SUCCESS or
 * FAILURE).
 */

int CfgGetStr (const char* Section,
               const char* Entry,
               const char* DefVal,
               char* Str,
               unsigned StrSize);
/* Read a string entry from the config file. Return the default in Str if the
 * section/entry was not found. DefVal and Str may point to the same string!
 * The function itself returns SUCCESS if the entry has been found and FAILURE
 * otherwise.
 */

int CfgHaveSection (const char* Section);
/* Return YES if the named section exists in the config file, return NO
 * otherwise.
 */

unsigned long CfgListSections (FILE* F);
/* List all available sections, each on a line, return the bytes written. */

int CfgInit (void);
/* Open the config file. Return SUCCESS/FAILURE */

void CfgDone (void);
/* Close the config file if it is open */



/* End of CONFIG.H */

#endif



