/*****************************************************************************/
/*                                                                           */
/* 				    util.c				     */
/*                                                                           */
/* 			      Utility functions.			     */
/*                                                                           */
/*                                                                           */
/*                                                                           */
/* (C) 1998     Ullrich von Bassewitz                                        */
/*              Wacholderweg 14                                              */
/*              D-70597 Stuttgart                                            */
/* EMail:       uz@musoftware.de                                             */
/*                                                                           */
/*                                                                           */
/* This software is provided 'as-is', without any express or implied         */
/* warranty.  In no event will the authors be held liable for any damages    */
/* arising from the use of this software.                                    */
/*                                                                           */
/* Permission is granted to anyone to use this software for any purpose,     */
/* including commercial applications, and to alter it and redistribute it    */
/* freely, subject to the following restrictions:                            */
/*                                                                           */
/* 1. The origin of this software must not be misrepresented; you must not   */
/*    claim that you wrote the original software. If you use this software   */
/*    in a product, an acknowledgment in the product documentation would be  */
/*    appreciated but is not required.                                       */
/* 2. Altered source versions must be plainly marked as such, and must not   */
/*    be misrepresented as being the original software.                      */
/* 3. This notice may not be removed or altered from any source              */
/*    distribution.                                                          */
/*                                                                           */
/*****************************************************************************/



#ifndef UTIL_H
#define UTIL_H



#include <stdlib.h>



/*****************************************************************************/
/* 				     Code				     */
/*****************************************************************************/



char* AddPathSep (char* Dir);
/* Add a trailing path separator if the given path does not end in one */

char* DelPathSep (char* Path);
/* Delete a trailing path separator if the last char of path is one */

char* DirCat (char* Path, const char* NewElement);
/* Add the new path element in NewElement to the given path. The function makes
 * shure that the path separator is handled correct. The complete path is
 * stored in Path, a pointer to path is returned.
 */

int IsDir (const char* Path);
/* Return YES if the name denotes an existing directory, return NO if not */

char* StrNCopy (char* Dest, const char* Src, size_t Size);
/* Does what strncpy should do (but doesn't): Copy Src to Dest, where Size is
 * the Size of the memory location that Dest points to. The resulting string
 * is terminated with a NUL character in any case. The function returns a
 * pointer to Dest.
 */

int IsReadable (const char* Path);
/* Return YES if the file with the given name exists and is readable,
 * return NO if not.
 */

int IsAbsolute (const char* Path);
/* Return YES is Path is an absolute path. Return NO if not. */



/* End of UTIL.H */

#endif



